/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/* @(#)38       1.5  src/avs/fs/mmfs/ts/kernext/ibm-kxi/cxiCred.h, mmfs, avs_remp, rempt1d1 4/1/01 18:22:40 */
#ifndef _h_CXICRED
#define _h_CXICRED

#include <cxiSystem.h>
#include <cxiTypes.h>

/* Structures dealing with ext_id_t and ext_cred_t
 * Equivalent to DCE uuid_t
 */
struct ext_id_t
{
  unsigned int            time_low;
  unsigned short          time_mid;
  unsigned short          time_hi_and_version;
  unsigned char           clock_seq_hi_and_reserved;
  unsigned char           clock_seq_low;
  unsigned char           node[6];
};
typedef struct ext_id_t ext_id_t;


/* Include platform-specific credential definitions */
#include <cxiCred-plat.h>


/* Compare a UUID to our (shortened) principal identifier
 */
#define PRINCIPAL_ID_COMPARE(idBlob1P, idBlob2P) \
  (cxiMemcmp((char *)(idBlob1P), (char *)(idBlob2P), sizeof(cxiGid_t)))

/* Compare as full length (128 bit) identifiers
 */
#define EXT_ID_COMPARE(idBlob1P, idBlob2P) \
  (cxiMemcmp((char *)(idBlob1P), (char *)(idBlob2P), sizeof(ext_id_t)))


/* We often compare the realm against a NIL identifier since
 * the local realm has the well known identity of NIL.  We need
 * a well known identity since a file may be accessed from a DFS
 * client and a GPFS node.  The DFS server node can correctly
 * tell us what a local realm identity is, but a normal GPFS
 * node has no idea how to interpret a 128 bit DCE realm.  Hence
 * we always store local realms as the well known NIL identity.
 */
#define NIL_EXT_ID(_IDP) \
  ((_IDP)->time_low == 0 && \
   (_IDP)->time_mid == 0 && \
   (_IDP)->time_hi_and_version == 0 && \
   (_IDP)->clock_seq_hi_and_reserved == 0 && \
   (_IDP)->clock_seq_low == 0 && \
   (_IDP)->node[0] == 0 && \
   (_IDP)->node[1] == 0 && \
   (_IDP)->node[2] == 0 && \
   (_IDP)->node[3] == 0 && \
   (_IDP)->node[4] == 0 && \
   (_IDP)->node[5] == 0)

/* Maximum character buffer size needed to represent a
 * extended identifier as a string.  (See EXT_ID_SPRINTF)
 */
#define EXT_ID_STRING_SIZE 37

#define EXT_ID_SPRINTF(_STRINGP, _IDP)       \
  sprintf((_STRINGP),                        \
          "%08X-%04X-%04X-%02X%02X-%02X%02X%02X%02X%02X%02X", \
          (_IDP)->time_low,                  \
          (_IDP)->time_mid,                  \
          (_IDP)->time_hi_and_version,       \
          (_IDP)->clock_seq_hi_and_reserved, \
          (_IDP)->clock_seq_low,             \
          (unsigned char)(_IDP)->node[0],    \
          (unsigned char)(_IDP)->node[1],    \
          (unsigned char)(_IDP)->node[2],    \
          (unsigned char)(_IDP)->node[3],    \
          (unsigned char)(_IDP)->node[4],    \
          (unsigned char)(_IDP)->node[5]);

/* prototypes */
char *ext_id_as_string(ext_id_t *, char *);

#endif /* _h_CXICRED */
